<?php

class Dynasty_MenuController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction() {
        // action body
        if (Application_Model_RolePermissionLogic::isPermitted("Menu:Master")) {
            
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonAction() {
        $this->_helper->layout()->disableLayout();
        $obj_menu = new Application_Model_MenuLogic(-1);
        echo $obj_menu->fetchDataTableSelect();
    }

    public function addAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Menu:Add")) {
            $obj_form = new Application_Form_Menu();
            $this->view->form = $obj_form;
            $obj_asitmenu = new Application_Model_Menu(-1);
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitmenu->set_menu_title($obj_form->menu_title->getValue());
                    $obj_asitmenu->set_menu_desc($obj_form->menu_desc->getValue());
                    $obj_asitmenu->set_menu_content($obj_form->menu_content->getValue());
                    $obj_asitmenu->set_menu_url($obj_form->menu_url->getValue());
                    $obj_asitmenu->set_menu_type($obj_form->menu_type->getValue());
                    $obj_asitmenu->set_menu_parent($obj_form->menu_parent->getValue());
                    $obj_asitmenu->set_menu_status($obj_form->menu_status->getValue());
                    $obj_asitmenu->set_menu_order($obj_form->menu_order->getValue());
                    $obj_asitmenu->set_menu_updated_by($user->getLoggedInUserId());
                    $obj_asitmenu->set_menu_created_by($user->getLoggedInUserId());
                    $obj_asitmenu->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Menu Added Successfully!!!";
                    $this->_redirect("dynasty/menu/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Menu:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Menu();
            $obj_asitmenu = new Application_Model_MenuLogic($id);
            $obj_form->menu_title->setValue($obj_asitmenu->get_menu_title());
            $obj_form->menu_desc->setValue($obj_asitmenu->get_menu_desc());
            $obj_form->menu_url->setValue($obj_asitmenu->get_menu_url());
            $obj_form->menu_type->setValue($obj_asitmenu->get_menu_type());
            foreach($obj_asitmenu->getMenuContent($obj_asitmenu->get_menu_type()) as $key=>$value) {
                $obj_form->menu_content->addMultiOption($key, $value);
            }
            $obj_form->menu_content->setValue($obj_asitmenu->get_menu_content());
            $obj_form->menu_parent->setValue($obj_asitmenu->get_menu_parent());
            $obj_form->menu_status->setValue($obj_asitmenu->get_menu_status());
            $obj_form->menu_order->setValue($obj_asitmenu->get_menu_order());
            $this->view->form = $obj_form;
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitmenu->set_menu_title($obj_form->menu_title->getValue());
                    $obj_asitmenu->set_menu_desc($obj_form->menu_desc->getValue());
                    $obj_asitmenu->set_menu_content($obj_form->menu_content->getValue());
                    $obj_asitmenu->set_menu_url($obj_form->menu_url->getValue());
                    $obj_asitmenu->set_menu_type($obj_form->menu_type->getValue());
                    $obj_asitmenu->set_menu_parent($obj_form->menu_parent->getValue());
                    $obj_asitmenu->set_menu_status($obj_form->menu_status->getValue());
                    $obj_asitmenu->set_menu_order($obj_form->menu_order->getValue());
                    $obj_asitmenu->set_menu_updated_by($user->getLoggedInUserId());
                    $obj_asitmenu->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Record Updated Successfully!!!";
                    $this->_redirect("dynasty/menu/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Menu:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            
            $obj_asitmenu = new Application_Model_MenuLogic($id);
            $obj_asitmenu->set_menu_status('D');
            $obj_asitmenu->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Menu Removed Successfully!!!";
            $this->_redirect("dynasty/menu/index");
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function contentAction() {
        $this->_helper->layout()->disableLayout();
        $type = $this->_getParam('type');
        $obj_menu = new Application_Model_MenuLogic(-1);
        $this->view->results = $obj_menu->getMenuContent($type);
    }

    public function urlAction() {
        $this->_helper->layout()->disableLayout();
        $type = $this->_getParam('type');
        $id = $this->_getParam('id');
        $obj_menu = new Application_Model_MenuLogic(-1);
        echo $obj_menu->getMenuUrl($type, $id);
    }

}
