<?php

class Dynasty_MessageController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        $id = $this->_getParam('id');
        $obj_msg = new Application_Model_MessageLogic($id);
        $this->view->msg = $obj_msg;
    }
    
    public function inboxAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:Inbox")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonInboxAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_msg = new Application_Model_MessageLogic(-1);
        echo $obj_msg->getInboxMessage();
    }
    
    public function outboxAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:Outbox")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonOutboxAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_msg = new Application_Model_MessageLogic(-1);
        echo $obj_msg->getOutboxMessage();
    }

    public function draftAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:Draft")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonDraftAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_msg = new Application_Model_MessageLogic(-1);
        echo $obj_msg->getDraftMessage();
    }
    
    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:New")) {
            $id = $this->_getParam('id');
            $obj_user = new Application_Model_UserLogic(-1);
            $obj_msg = new Application_Model_MessageLogic($id);
            if($obj_msg->get_message_status() == 'Draft' && $obj_msg->get_message_from_id() == $obj_user->getLoggedInUserId()) {
                $obj_form = new Application_Form_Message();
                $obj_form->message_to->setValue($obj_msg->get_message_to_id());
                $obj_form->message_subject->setValue($obj_msg->get_message_subject());
                $obj_form->message_content->setValue($obj_msg->get_message_content());
                $this->view->form = $obj_form;
                if($this->getRequest()->isPost()) {
                    $data = $this->getRequest()->getPost();
                    $obj_msg->set_message_from_id($obj_user->getLoggedInUserId());
                    $obj_msg->set_message_to_id($data['message_to']);
                    $obj_msg->set_message_is_view(false);
                    $obj_msg->set_message_subject($data['message_subject']);
                    $obj_msg->set_message_content($data['message_content']);
                    $obj_msg->set_message_status($data['message_action']);
                    $obj_msg->set_message_updated_by($obj_user->getLoggedInUserId());
                    $obj_msg->save();
                    
                    if($data["message_action"] == 'Send') {
                        $obj_alert = new Application_Model_AlertLogic(-1);
                        $obj_alert->insertAlert('New Message Recieved.', $obj_user->getLoggedInUser()->get_user_name().' sent you a message with subject '.$data['message_subject'].'.', $data['message_to']);
                    }

                    $sess = new Zend_Session_Namespace('msg');
                    $sess->msg = (($data["message_action"] == 'Draft') ? 'Message Saved.' : 'Message Send.');
                    $this->_redirect('dynasty/message/inbox');
                }
            }else {
                $sess = new Zend_Session_Namespace('msg');
                $sess->error = 'Sorry, you can not edit the message.';
                $this->_redirect('dynasty/message/inbox');
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function newAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:New")) {
            $obj_form = new Application_Form_Message();
            $toId = $this->_getParam('to');
            if($toId != null) {
                $obj_form->message_to->setValue($toId);
            }
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                Zend_Debug::dump($data);
                $obj_user = new Application_Model_UserLogic(-1);
                $obj_msg = new Application_Model_MessageLogic(-1);
                $obj_msg->set_message_from_id($obj_user->getLoggedInUserId());
                $obj_msg->set_message_to_id($data['message_to']);
                $obj_msg->set_message_is_view(false);
                $obj_msg->set_message_subject($data['message_subject']);
                $obj_msg->set_message_content($data['message_content']);
                $obj_msg->set_message_status($data['message_action']);
                $obj_msg->set_message_created_by($obj_user->getLoggedInUserId());
                $obj_msg->set_message_updated_by($obj_user->getLoggedInUserId());
                $obj_msg->save();

                if($data["message_action"] == 'Send') {
                    $obj_alert = new Application_Model_AlertLogic(-1);
                    $obj_alert->insertAlert('New Message Recieved.', $obj_user->getLoggedInUser()->get_user_name().' sent you a message with subject '.$data['message_subject'].'.', $data['message_to']);
                }
                
                $sess = new Zend_Session_Namespace('msg');
                $sess->msg = (($data["message_action"] == 'Draft') ? 'Message Saved.' : 'Message Send.');
                $this->_redirect('dynasty/message/inbox');
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function saveAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:New")) {
            $this->_helper->layout()->disableLayout();
            if($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                Zend_Debug::dump($data);
                $obj_user = new Application_Model_UserLogic(-1);
                $obj_msg = new Application_Model_MessageLogic(-1);
                $obj_msg->set_message_from_id($obj_user->getLoggedInUserId());
                $obj_msg->set_message_to_id($data['message_to']);
                $obj_msg->set_message_is_view(false);
                $obj_msg->set_message_subject($data['message_subject']);
                $obj_msg->set_message_content($data['message_content']);
                $obj_msg->set_message_status('Draft');
                $obj_msg->set_message_created_by($obj_user->getLoggedInUserId());
                $obj_msg->set_message_updated_by($obj_user->getLoggedInUserId());
                $obj_msg->save();
                echo $obj_msg->getAdapter()->lastInsertId();
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Message:Delete")) {
            $id = $this->_getParam('id');
            $obj_user = new Application_Model_UserLogic(-1);
            $obj_msg = new Application_Model_MessageLogic($id);
            $sess = new Zend_Session_Namespace('msg');
            if($obj_msg->get_message_from_id() == $obj_user->getLoggedInUserId() || $obj_msg->get_message_to_id() == $obj_user->getLoggedInUserId()) {
                $obj_msg->set_message_status('Delete');
                $obj_msg->save();
                $sess->msg = 'Message Deleted Successfully.';
                $this->_redirect('dynasty/message/inbox');
            }else {
                $sess->error = 'Message Can Not Be Delete.';
                $this->_redirect('dynasty/message/inbox');
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
}

