<?php

class Dynasty_NewsController extends Zend_Controller_Action
{
    
    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }
    
    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("News:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_news = new Application_Model_NewsLogic(-1);
        echo $obj_news->fetchDataTableSelect();
    }
    
    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("News:Add")) {
            $obj_form = new Application_Form_News();
            $this->view->form = $obj_form;
            $obj_asitnews = new Application_Model_NewsLogic(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitnews->set_news_title($obj_form->news_title->getValue());
                    $obj_asitnews->set_news_image($obj_form->news_image->getValue());
                    $obj_asitnews->set_news_short_desc($obj_form->news_short_desc->getValue());
                    $obj_asitnews->set_news_desc($obj_form->news_desc->getValue());
                    $obj_asitnews->set_news_url($obj_asitnews->generateNewsUrl($obj_form->news_title->getValue()));
                    $obj_asitnews->set_news_meta_key($obj_form->news_meta_key->getValue());
                    $obj_asitnews->set_news_meta_desc($obj_form->news_meta_desc->getValue());
                    $obj_asitnews->set_news_status('A');
                    $obj_asitnews->set_news_updated_by($user->getLoggedInUserId());
                    $obj_asitnews->set_news_created_by($user->getLoggedInUserId());
                    $obj_asitnews->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "News Created Successfully!!!";
                    $this->_redirect("dynasty/news/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("News:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_News();
            $obj_asitnews = new Application_Model_News($id);
            $obj_form->news_title->setValue($obj_asitnews->get_news_title());
            $obj_form->news_image->setRequired(false);
            $obj_form->news_short_desc->setValue($obj_asitnews->get_news_short_desc());
            $obj_form->news_desc->setValue($obj_asitnews->get_news_desc());
            $obj_form->news_meta_key->setValue($obj_asitnews->get_news_meta_key());
            $obj_form->news_meta_desc->setValue($obj_asitnews->get_news_meta_desc());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitnews->set_news_title($obj_form->news_title->getValue());
                    if(count(explode('.', $obj_form->news_image->getValue())) > 1) {
                        $obj_asitnews->set_news_image($obj_form->news_image->getValue());
                    }
                    $obj_asitnews->set_news_short_desc($obj_form->news_short_desc->getValue());
                    $obj_asitnews->set_news_desc($obj_form->news_desc->getValue());
                    $obj_asitnews->set_news_meta_key($obj_form->news_meta_key->getValue());
                    $obj_asitnews->set_news_meta_desc($obj_form->news_meta_desc->getValue());
                    $obj_asitnews->set_news_updated_by($user->getLoggedInUserId());
                    $obj_asitnews->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "News Updated Successfully!!!";
                    $this->_redirect("dynasty/news/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("News:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitnews = new Application_Model_NewsLogic($id);
            $obj_asitnews->set_news_status('D');
            $obj_asitnews->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "News Removed Successfully!!!";
            $this->_redirect("dynasty/news/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    
}
