<?php

class Dynasty_PageController extends Zend_Controller_Action
{
    
    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }
    
    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Page:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_page = new Application_Model_PageLogic(-1);
        echo $obj_page->fetchDataTableSelect();
    }
    
    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Page:Add")) {
            $obj_form = new Application_Form_Page();
            $this->view->form = $obj_form;
            $obj_asitpage = new Application_Model_PageLogic(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitpage->set_page_title($obj_form->page_title->getValue());
                    //$obj_asitpage->set_page_image($obj_form->page_image->getValue());
                    $obj_asitpage->set_page_short_desc($obj_form->page_short_desc->getValue());
                    $obj_asitpage->set_page_desc($obj_form->page_desc->getValue());
                    $obj_asitpage->set_page_url($obj_asitpage->generatePageUrl($obj_form->page_title->getValue()));
                    $obj_asitpage->set_page_meta_key($obj_form->page_meta_key->getValue());
                    $obj_asitpage->set_page_meta_desc($obj_form->page_meta_desc->getValue());
                    $obj_asitpage->set_page_status($obj_form->page_status->getValue());
                    $obj_asitpage->set_page_updated_by($user->getLoggedInUserId());
                    $obj_asitpage->set_page_created_by($user->getLoggedInUserId());
                    $obj_asitpage->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Page Created Successfully!!!";
                    $this->_redirect("dynasty/page/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Page:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Page();
            $obj_asitpage = new Application_Model_Page($id);
            $obj_form->page_title->setValue($obj_asitpage->get_page_title());
            //$obj_form->page_image->setRequired(false);
            $obj_form->page_short_desc->setValue($obj_asitpage->get_page_short_desc());
            $obj_form->page_desc->setValue($obj_asitpage->get_page_desc());
            $obj_form->page_meta_key->setValue($obj_asitpage->get_page_meta_key());
            $obj_form->page_meta_desc->setValue($obj_asitpage->get_page_meta_desc());
            $obj_form->page_status->setValue($obj_asitpage->get_page_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitpage->set_page_title($obj_form->page_title->getValue());
                    /*if(count(explode('.', $obj_form->page_image->getValue())) > 1) {
                        $obj_asitpage->set_page_image($obj_form->page_image->getValue());
                    }*/
                    $obj_asitpage->set_page_short_desc($obj_form->page_short_desc->getValue());
                    $obj_asitpage->set_page_desc($obj_form->page_desc->getValue());
                    $obj_asitpage->set_page_meta_key($obj_form->page_meta_key->getValue());
                    $obj_asitpage->set_page_meta_desc($obj_form->page_meta_desc->getValue());
                    $obj_asitpage->set_page_status($obj_form->page_status->getValue());
                    $obj_asitpage->set_page_updated_by($user->getLoggedInUserId());
                    $obj_asitpage->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Page Updated Successfully!!!";
                    $this->_redirect("dynasty/page/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Page:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitpage = new Application_Model_PageLogic($id);
            $obj_asitpage->set_page_status('D');
            $obj_asitpage->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Page Removed Successfully!!!";
            $this->_redirect("dynasty/page/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    
}
