<?php

class Dynasty_PermissionController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Permission:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_per = new Application_Model_PermissionLogic(-1);
        echo $obj_per->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Permission:Add")) {
            $obj_form = new Application_Form_Permission();
            $this->view->form = $obj_form;
            $obj_cloudcannypermission = new Application_Model_Permission(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $obj_cloudcannypermission->set_permission_title($obj_form->permission_title->getValue());
                 $obj_cloudcannypermission->set_permission_key($obj_form->permission_key->getValue());
                 $user = new Application_Model_UserLogic(-1);
                 $obj_cloudcannypermission->set_permission_created_by($user->getLoggedInUser()->get_id());
                 $obj_cloudcannypermission->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Permission Created Successfully!!!";
                 $this->_redirect("dynasty/permission/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Permission:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Permission();
            $obj_cloudcannypermission = new Application_Model_Permission($id);
            $obj_form->permission_title->setValue($obj_cloudcannypermission->get_permission_title());
            $obj_form->permission_key->setValue($obj_cloudcannypermission->get_permission_key());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $obj_cloudcannypermission->set_permission_title($obj_form->permission_title->getValue());
                 $obj_cloudcannypermission->set_permission_key($obj_form->permission_key->getValue());
                 $obj_cloudcannypermission->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Permission Updated Successfully!!!";
                 $this->_redirect("dynasty/permission/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Permission:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_cloudcannypermission = new Application_Model_Permission($id);
            $obj_cloudcannypermission->remove();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Permission Removed Successfully!!!";
            $this->_redirect("dynasty/permission/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

}

