<?php

class Dynasty_ReviewController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction() {
        // action body
        if (Application_Model_RolePermissionLogic::isPermitted("Review:Master")) {
            $this->view->id = $id = $this->_getParam('id');
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonAction() {
        $this->_helper->layout()->disableLayout();
        $obj_review = new Application_Model_ReviewLogic(-1);
        echo $obj_review->fetchDataTableSelect($this->_getParam('id'));
    }

    public function editAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Review:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Review();
            $obj_asitlistreview = new Application_Model_ReviewLogic($id);
            $this->view->listId = $obj_asitlistreview->get_review_list();
            $obj_form->review_list->setValue($obj_asitlistreview->get_review_list());
            $obj_form->review_score->setValue($obj_asitlistreview->get_review_score());
            $obj_form->review_subject->setValue($obj_asitlistreview->get_review_subject());
            $obj_form->review_body->setValue($obj_asitlistreview->get_review_body());
            $obj_form->review_status->setValue($obj_asitlistreview->get_review_status());
            $this->view->form = $obj_form;
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitlistreview->set_review_score($obj_form->review_score->getValue());
                    $obj_asitlistreview->set_review_subject($obj_form->review_subject->getValue());
                    $obj_asitlistreview->set_review_body($obj_form->review_body->getValue());
                    $obj_asitlistreview->set_review_status($obj_form->review_status->getValue());
                    $obj_asitlistreview->set_review_updated_by($user->getLoggedInUserId());
                    $obj_asitlistreview->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Record Updated Successfully!!!";
                    $this->_redirect("dynasty/review/index/id/" . $obj_asitlistreview->get_review_list());
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Review:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitreview = new Application_Model_ReviewLogic($id);
            $obj_asitreview->set_review_status('D');
            $obj_asitreview->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Review Removed Successfully!!!";
            $this->_redirect("dynasty/review/index/id/" . $obj_asitreview->get_review_list());
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

}
