<?php

class Dynasty_SliderController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction() {
        // action body
        if (Application_Model_RolePermissionLogic::isPermitted("Slider:Master")) {
            
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function jsonAction() {
        $this->_helper->layout()->disableLayout();
        $obj_slider = new Application_Model_SliderLogic(-1);
        echo $obj_slider->fetchDataTableSelect();
    }

    public function addAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Slider:Add")) {
            $obj_form = new Application_Form_Slider();
            $this->view->form = $obj_form;
            $obj_asitslider = new Application_Model_SliderLogic(-1);
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitslider->set_slider_title($obj_form->slider_title->getValue());
                    $obj_asitslider->set_slider_image($obj_form->slider_image->getValue());
                    $obj_asitslider->set_slider_status($obj_form->slider_status->getValue());
                    $obj_asitslider->set_slider_updated_by($user->getLoggedInUserId());
                    $obj_asitslider->set_slider_created_by($user->getLoggedInUserId());
                    $obj_asitslider->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Image Added Successfully!!!";
                    $this->_redirect("dynasty/slider/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Slider:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Slider();
            $obj_asitslider = new Application_Model_SliderLogic($id);
            $obj_form->slider_title->setValue($obj_asitslider->get_slider_title());
            $obj_form->slider_image->setRequired(false);
            $obj_form->slider_status->setValue($obj_asitslider->get_slider_status());
            $this->view->form = $obj_form;
            if ($this->getRequest()->isPost()) {
                $data = $this->getRequest()->getPost();
                if ($obj_form->isValid($data)) {
                    $user = new Application_Model_UserLogic(-1);
                    $obj_asitslider->set_slider_title($obj_form->slider_title->getValue());
                    if(count(explode('.', $obj_form->slider_image->getValue())) > 1) {
                        $obj_asitslider->set_slider_image($obj_form->slider_image->getValue());
                    }
                    $obj_asitslider->set_slider_status($obj_form->slider_status->getValue());
                    $obj_asitslider->set_slider_updated_by($user->getLoggedInUserId());
                    $obj_asitslider->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Image Updated Successfully!!!";
                    $this->_redirect("dynasty/slider/index");
                }
            }
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction() {
        if (Application_Model_RolePermissionLogic::isPermitted("Slider:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            
            $obj_asitslide = new Application_Model_SliderLogic($id);
            $obj_asitslide->set_slider_status('D');
            $obj_asitslide->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Image Removed Successfully!!!";
            $this->_redirect("dynasty/slider/index");
        } else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
}
