<?php

class Dynasty_TagController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Tag:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_tag = new Application_Model_TagLogic(-1);
        echo $obj_tag->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tag:Add")) {
            $obj_form = new Application_Form_Tag();
            $this->view->form = $obj_form;
            $obj_tag = new Application_Model_Tag(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $obj_tag->set_tag_title($obj_form->tag_title->getValue());
                 $obj_tag->set_tag_status('A');
                 $user = new Application_Model_UserLogic(-1);
                 $obj_tag->set_tag_created_by($user->getLoggedInUser()->get_id());
                 $obj_tag->set_tag_updated_by($user->getLoggedInUser()->get_id());
                 $obj_tag->save();
                 
                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Tag Created Successfully!!!";
                 $this->_redirect("dynasty/tag/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tag:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Tag();
            $obj_tag = new Application_Model_Tag($id);
            $obj_form->tag_title->setValue($obj_tag->get_tag_title());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $obj_tag->set_tag_title($obj_form->tag_title->getValue());
                 $user = new Application_Model_UserLogic(-1);
                 $obj_tag->set_tag_updated_by($user->getLoggedInUser()->get_id());
                 $obj_tag->save();
                 
                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Tag Updated Successfully!!!";
                 $this->_redirect("dynasty/tag/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tag:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_tag = new Application_Model_Tag($id);
            $obj_tag->set_tag_status('D');
            $obj_tag->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Tag Removed Successfully!!!";
            $this->_redirect("dynasty/tag/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

