<?php

class Dynasty_TcController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Tc:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_tc = new Application_Model_TcLogic(-1);
        echo $obj_tc->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tc:Add")) {
            $obj_form = new Application_Form_Tc();
            $this->view->form = $obj_form;
            $obj_asittc = new Application_Model_TcLogic(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asittc->set_tc_student($obj_form->tc_student->getValue());
                    $obj_asittc->set_tc_file($obj_form->tc_file->getValue());
                    $obj_asittc->set_tc_download(0);
                    $obj_asittc->set_tc_status('A');
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asittc->set_tc_updated_by($obj_user->getLoggedInUserId());
                    $obj_asittc->set_tc_created_by($obj_user->getLoggedInUserId());
                    $obj_asittc->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Tc Created Successfully!!!";
                    $this->_redirect("dynasty/tc/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tc:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Tc();
            $obj_asittc = new Application_Model_TcLogic($id);
            $obj_form->tc_student->setValue($obj_asittc->get_tc_student());
            $obj_form->tc_file->setRequired(false);
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asittc->set_tc_student($obj_form->tc_student->getValue());
                    if(count(explode('.', $obj_form->tc_file->getValue())) > 1) {
                        $obj_asittc->set_tc_file($obj_form->tc_file->getValue());
                    }
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asittc->set_tc_updated_by($obj_user->getLoggedInUserId());
                    $obj_asittc->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Tc Updated Successfully!!!";
                    $this->_redirect("dynasty/tc/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Tc:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_user = new Application_Model_UserLogic(-1);
            
            $obj_tc = new Application_Model_TcLogic($id);
            $obj_tc->set_tc_status('D');
            $obj_tc->set_tc_updated_by($obj_user->getLoggedInUserId());
            $obj_tc->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Tc Removed Successfully!!!";
            $this->_redirect("dynasty/tc/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

