<?php

class Dynasty_TodoController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Todo:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_todo = new Application_Model_TodoLogic(-1);
        echo $obj_todo->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Todo:Add")) {
            $obj_form = new Application_Form_Todo();
            $this->view->form = $obj_form;
            $obj_asittodo = new Application_Model_TodoLogic(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $user = new Application_Model_UserLogic(-1);  
                 $obj_asittodo->set_todo_title($obj_form->todo_title->getValue());
                 $obj_asittodo->set_todo_description($obj_form->todo_description->getValue());
                 $obj_asittodo->set_todo_from_date(date('Y-m-d', strtotime($obj_form->todo_from_date->getValue())));
                 $obj_asittodo->set_todo_to_date(date('Y-m-d', strtotime($obj_form->todo_to_date->getValue())));
                 $obj_asittodo->set_todo_role(0);
                 $obj_asittodo->set_todo_status('A');
                 $obj_asittodo->set_todo_updated_by($user->getLoggedInUserId());
                 $obj_asittodo->set_todo_created_by($user->getLoggedInUserId());
                 $obj_asittodo->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Todo Created Successfully!!!";
                 $this->_redirect("dynasty/todo/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Todo:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Todo();
            $obj_asittodo = new Application_Model_TodoLogic($id);
            $obj_form->todo_title->setValue($obj_asittodo->get_todo_title());
            $obj_form->todo_description->setValue($obj_asittodo->get_todo_description());
            $obj_form->todo_from_date->setValue(date('m/d/Y', strtotime($obj_asittodo->get_todo_from_date())));
            $obj_form->todo_to_date->setValue(date('m/d/Y', strtotime($obj_asittodo->get_todo_to_date())));
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
              $data=$this->getRequest()->getPost();
              if($obj_form->isValid($data)){
                 $user = new Application_Model_UserLogic(-1); 
                 $obj_asittodo->set_todo_title($obj_form->todo_title->getValue());
                 $obj_asittodo->set_todo_description($obj_form->todo_description->getValue());
                 $obj_asittodo->set_todo_from_date(date('Y-m-d', strtotime($obj_form->todo_from_date->getValue())));
                 $obj_asittodo->set_todo_to_date(date('Y-m-d', strtotime($obj_form->todo_to_date->getValue())));
                 $obj_asittodo->set_todo_updated_by($user->getLoggedInUserId());
                 $obj_asittodo->save();

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Todo Updated Successfully!!!";
                 $this->_redirect("dynasty/todo/index");
              }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Todo:Delete")) {
            $id = $this->_getParam("id");
            $obj_asittodo = new Application_Model_TodoLogic($id);
            $obj_asittodo->remove();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Todo Removed Successfully!!!";
            $this->_redirect("dynasty/todo/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
