<?php

class Dynasty_TopperController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Topper:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_tag = new Application_Model_TopperLogic(-1);
        echo $obj_tag->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Topper:Add")) {
            $obj_form = new Application_Form_Topper();
            $this->view->form = $obj_form;
            $obj_asittoppers = new Application_Model_TopperLogic(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asittoppers->set_topper_name($obj_form->topper_name->getValue());
                    $obj_asittoppers->set_topper_class($obj_form->topper_class->getValue());
                    $obj_asittoppers->set_topper_percent($obj_form->topper_percent->getValue());
                    $obj_asittoppers->set_topper_status('A');
                    $obj_asittoppers->set_topper_updated_by($obj_user->getLoggedInUserId());
                    $obj_asittoppers->set_topper_created_by($obj_user->getLoggedInUserId());
                    $obj_asittoppers->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Record Created Successfully!!!";
                    $this->_redirect("dynasty/topper/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Topper:Edit")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam("id"));
            $obj_form = new Application_Form_Topper();
            $obj_asittoppers = new Application_Model_TopperLogic($id);
            $obj_form->topper_name->setValue($obj_asittoppers->get_topper_name());
            $obj_form->topper_class->setValue($obj_asittoppers->get_topper_class());
            $obj_form->topper_percent->setValue($obj_asittoppers->get_topper_percent());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $obj_asittoppers->set_topper_name($obj_form->topper_name->getValue());
                    $obj_asittoppers->set_topper_class($obj_form->topper_class->getValue());
                    $obj_asittoppers->set_topper_percent($obj_form->topper_percent->getValue());
                    $obj_user = new Application_Model_UserLogic(-1);
                    $obj_asittoppers->set_topper_updated_by($obj_user->getLoggedInUserId());
                    $obj_asittoppers->save();

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Topper Updated Successfully!!!";
                    $this->_redirect("dynasty/topper/index");
                 }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Topper:Delete")) {
            $enc = new Application_Model_Util_Encrypt();
            $id = $enc->showHiddenContent($this->_getParam('id'));
            $obj_topper = new Application_Model_Topper($id);
            $obj_topper->set_topper_status('D');
            $obj_user = new Application_Model_UserLogic(-1);
            $obj_topper->set_topper_updated_by($obj_user->getLoggedInUserId());
            $obj_topper->save();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Topper Removed Successfully!!!";
            $this->_redirect("dynasty/topper/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}

