<?php

class Dynasty_UserController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("User:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_user = new Application_Model_UserLogic(-1);
        echo $obj_user->fetchDataTableSelect();
    }

    public function addAction()
    {
        $obj_form = new Application_Form_User();
        $this->view->form = $obj_form;
        $obj_asituser = new Application_Model_UserLogic(-1);
        if($this->getRequest()->isPost()){
           $data=$this->getRequest()->getPost();
           if($obj_form->isValid($data)){
             $sess = new Zend_Session_Namespace("msg");
             if($obj_asituser->checkUserIdExist($obj_form->user_id->getValue())) {
                $sess->error = "User Id Already Exist!!!";
                //$this->_redirect("dynasty/user/index");
             }elseif($obj_asituser->checkEmailExist($obj_form->user_email->getValue())) {
                $sess->error = "User Email Already Exist!!!";
                //$this->_redirect("dynasty/user/index");
             }else {
                $obj_asituser->set_user_id($obj_form->user_id->getValue());
                $obj_asituser->set_user_password(sha1($obj_form->user_password->getValue()));
                $obj_asituser->set_user_name($obj_form->user_name->getValue());
                $obj_asituser->set_user_email($obj_form->user_email->getValue());
                $obj_asituser->set_user_mobile($obj_form->user_mobile->getValue());
                $obj_asituser->set_user_dob(date('Y-m-d', strtotime($obj_form->user_dob->getValue())));
                $obj_asituser->set_user_gender($obj_form->user_gender->getValue());
                $obj_asituser->set_user_role($obj_form->user_role->getValue());
                $obj_asituser->set_user_status($obj_form->user_status->getValue());
                $obj_asituser->set_user_token(sha1(rand(1, 99999999999)));
                $obj_asituser->set_user_updated_by($obj_asituser->getLoggedInUserId());
                $obj_asituser->set_user_created_by($obj_asituser->getLoggedInUserId());
                $obj_asituser->save();
                
                $sess->msg = "User Created Successfully!!!";
                $this->_redirect("dynasty/user/index");
             }
        
             
           }
        }
    }

    public function editAction()
    {
        $id = $this->_getParam("id");
        $obj_form = new Application_Form_User();
        $obj_asituser = new Application_Model_UserLogic($id);
        $obj_form->user_id->setAttrib('readOnly', 'readOnly');
        $obj_form->user_password->setRequired(false);
        $obj_form->user_id->setValue($obj_asituser->get_user_id());
        $obj_form->user_name->setValue($obj_asituser->get_user_name());
        $obj_form->user_email->setValue($obj_asituser->get_user_email());
        $obj_form->user_mobile->setValue($obj_asituser->get_user_mobile());
        $obj_form->user_dob->setValue(date('d-M-Y', strtotime($obj_asituser->get_user_dob())));
        $obj_form->user_gender->setValue($obj_asituser->get_user_gender());
        $obj_form->user_role->setValue($obj_asituser->get_user_role());
        $obj_form->user_status->setValue($obj_asituser->get_user_status());
        $this->view->form = $obj_form;
        if($this->getRequest()->isPost()){
          $data=$this->getRequest()->getPost();
          if($obj_form->isValid($data)){
             $password = $obj_form->user_password->getValue(); 
             if($password != null && $password != '') { 
                $obj_asituser->set_user_password(sha1($obj_form->user_password->getValue()));
             }
             $obj_asituser->set_user_name($obj_form->user_name->getValue());
             $obj_asituser->set_user_email($obj_form->user_email->getValue());
             $obj_asituser->set_user_mobile($obj_form->user_mobile->getValue());
             $obj_asituser->set_user_dob(date('Y-m-d', strtotime($obj_form->user_dob->getValue())));
             $obj_asituser->set_user_gender($obj_form->user_gender->getValue());
             $obj_asituser->set_user_role($obj_form->user_role->getValue());
             $obj_asituser->set_user_status($obj_form->user_status->getValue());
             $obj_asituser->set_user_updated_by($obj_asituser->getLoggedInUserId());
             $obj_asituser->save();
        
             $sess = new Zend_Session_Namespace("msg");
             $sess->msg = "User Updated Successfully!!!";
             $this->_redirect("dynasty/user/index");
          }
        }
    }

    public function deleteAction()
    {
        $id = $this->_getParam("id");
        $obj_asituser = new Application_Model_UserLogic($id);
        $obj_asituser->set_user_status('D');
        $obj_asituser->save();
        
        $sess = new Zend_Session_Namespace("msg");
        $sess->msg = "User Removed Successfully!!!";
        $this->_redirect("dynasty/user/index");
    }
    
    public function viewAction()
    {
        $id = $this->_getParam("id");
        $obj_asituser = new Application_Model_UserLogic($id);
        $this->view->user = $obj_asituser;
    }


}