<?php

class Dynasty_VideoController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Master")) {
            $this->view->id = $id = $this->_getParam('id');
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $id = $this->_getParam('id');
        $obj_video = new Application_Model_VideoLogic(-1);
        echo $obj_video->fetchDataTableSelect($id);
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Add")) {
            $this->view->id = $id = $this->_getParam('id');
            $obj_form = new Application_Form_Video();
            $this->view->form = $obj_form;
            $obj_video = new Application_Model_Video(-1);
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_video->set_video_title($obj_form->video_title->getValue());
                    $obj_video->set_video_desc($obj_form->video_desc->getValue());
                    $obj_video->set_video_code($obj_form->video_code->getValue());
                    $obj_video->set_video_album($id);
                    $obj_video->set_video_status($obj_form->video_status->getValue());
                    $obj_video->set_video_updated_by($user->getLoggedInUserId());
                    $obj_video->set_video_created_by($user->getLoggedInUserId());
                    $obj_video->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Record Created Successfully!!!";
                    $this->_redirect("dynasty/video/index/id/".$obj_video->get_video_album());
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Video();
            $obj_video = new Application_Model_Video($id);
            $this->view->id = $obj_video->get_video_album();
            $obj_form->video_title->setValue($obj_video->get_video_title());
            $obj_form->video_desc->setValue($obj_video->get_video_desc());
            $obj_form->video_code->setValue($obj_video->get_video_code());
            $obj_form->video_status->setValue($obj_video->get_video_status());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1);
                    $obj_video->set_video_title($obj_form->video_title->getValue());
                    $obj_video->set_video_desc($obj_form->video_desc->getValue());
                    $obj_video->set_video_code($obj_form->video_code->getValue());
                    $obj_video->set_video_status($obj_form->video_status->getValue());
                    $obj_video->set_video_updated_by($user->getLoggedInUserId());
                    $obj_video->save();
                    
                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Video Updated Successfully!!!";
                    $this->_redirect("dynasty/video/index/id/".$obj_video->get_video_album());
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Delete")) {
            $id = $this->_getParam("id");
            $obj_video = new Application_Model_VideoLogic($id);
            $obj_video->set_video_status('D');
            $obj_video->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Video Removed Successfully!!!";
            $this->_redirect("dynasty/video/index/id/".$obj_video->get_video_album());
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    

}

