<?php

class Dynasty_WorkController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Master")) {
            
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $obj_work = new Application_Model_WorkLogic(-1);
        echo $obj_work->fetchDataTableSelect();
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Add")) {
            $obj_form = new Application_Form_Work();
            $this->view->form = $obj_form;
            $obj_asitwork = new Application_Model_WorkLogic(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                 $user = new Application_Model_UserLogic(-1);  
                 $obj_asitwork->set_work_title($obj_form->work_title->getValue());
                 $obj_asitwork->set_work_description($obj_form->work_description->getValue());
                 $obj_asitwork->set_work_from_date(date('Y-m-d', strtotime($obj_form->work_from_date->getValue())));
                 $obj_asitwork->set_work_to_date(date('Y-m-d', strtotime($obj_form->work_to_date->getValue())));
                 $obj_asitwork->set_work_user_id(($obj_form->work_type->getValue() == 'U') ? $obj_form->work_to->getValue() : 0);
                 $obj_asitwork->set_work_role_id(($obj_form->work_type->getValue() == 'R') ? $obj_form->work_to->getValue() : 0);
                 $obj_asitwork->set_work_status('Assigned');
                 $obj_asitwork->set_work_remarks('Assigned by '.$user->getLoggedInUser()->get_user_name());
                 $obj_asitwork->set_work_priority($obj_form->work_priority->getValue());
                 $obj_asitwork->set_work_updated_by($user->getLoggedInUserId());
                 $obj_asitwork->set_work_created_by($user->getLoggedInUserId());
                 $obj_asitwork->save();
                 
                 $id = $obj_asitwork->getAdapter()->lastInsertId();
                 $obj_asitworkstatus = new Application_Model_WorkStatusLogic(-1);
                 $obj_asitworkstatus->set_work_id($id);
                 $obj_asitworkstatus->set_work_remarks('Assigned by '.$user->getLoggedInUser()->get_user_name());
                 $obj_asitworkstatus->set_work_status('Assigned');
                 $obj_asitworkstatus->set_work_updated_by($user->getLoggedInUserId());
                 $obj_asitworkstatus->set_work_created_by($user->getLoggedInUserId());
                 $obj_asitworkstatus->save();
                 
                 $obj_email = new Application_Model_Email_Factory();
                 $obj_email->sendWorkAllocationEmail($id);

                 $sess = new Zend_Session_Namespace("msg");
                 $sess->msg = "Work Allocated Successfully!!!";
                 $this->_redirect("dynasty/work/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function editAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Edit")) {
            $id = $this->_getParam("id");
            $obj_form = new Application_Form_Work();
            $obj_asitwork = new Application_Model_WorkLogic($id);
            $obj_form->work_title->setValue($obj_asitwork->get_work_title());
            $obj_form->work_description->setValue($obj_asitwork->get_work_description());
            $obj_form->work_from_date->setValue(date('m/d/Y', strtotime($obj_asitwork->get_work_from_date())));
            $obj_form->work_to_date->setValue(date('m/d/Y', strtotime($obj_asitwork->get_work_to_date())));
            if($obj_asitwork->get_work_user_id() == 0) {
                $obj_form->work_type->setValue('R');
                $obj_role = new Application_Model_RoleLogic(-1);
                foreach($obj_role->fetchAll() as $role) {
                    $obj_form->work_to->addMultiOption($role->id, $role->role_title);
                }
                $obj_form->work_to->setValue($obj_asitwork->get_work_role_id());
            }
            if($obj_asitwork->get_work_role_id() == 0) {
                $obj_form->work_type->setValue('U');
                $obj_user = new Application_Model_UserLogic(-1);
                foreach($obj_user->fetchAll() as $user) {
                    $obj_form->work_to->addMultiOption($user->id, $user->user_name);
                }
                $obj_form->work_to->setValue($obj_asitwork->get_work_user_id());
            }
            $obj_form->work_priority->setValue($obj_asitwork->get_work_priority());
            $this->view->form = $obj_form;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();
                if($obj_form->isValid($data)){
                    $user = new Application_Model_UserLogic(-1); 
                    $obj_asitwork->set_work_title($obj_form->work_title->getValue());
                    $obj_asitwork->set_work_description($obj_form->work_description->getValue());
                    $obj_asitwork->set_work_from_date(date('Y-m-d', strtotime($obj_form->work_from_date->getValue())));
                    $obj_asitwork->set_work_to_date(date('Y-m-d', strtotime($obj_form->work_to_date->getValue())));
                    $obj_asitwork->set_work_user_id(($obj_form->work_type->getValue() == 'U') ? $obj_form->work_to->getValue() : 0);
                    $obj_asitwork->set_work_role_id(($obj_form->work_type->getValue() == 'R') ? $obj_form->work_to->getValue() : 0);
                    $obj_asitwork->set_work_priority($obj_form->work_priority->getValue());
                    $obj_asitwork->set_work_updated_by($user->getLoggedInUserId());
                    $obj_asitwork->save();
                    
                    $obj_email = new Application_Model_Email_Factory();
                    $obj_email->sendWorkAllocationEmail($id, true);

                    $sess = new Zend_Session_Namespace("msg");
                    $sess->msg = "Work Allocation Updated Successfully!!!";
                    $this->_redirect("dynasty/work/index");
                }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

    public function deleteAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Delete")) {
            $id = $this->_getParam("id");
            $obj_asitwork = new Application_Model_WorkLogic($id);
            $obj_asitwork->set_work_status('D');
            $obj_asitwork->remove();

            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Work Allocation Removed Successfully!!!";
            $this->_redirect("dynasty/work/index");
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }


}
