<?php

class Dynasty_WorkStatusController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->setLayout('admin');
    }

    public function indexAction()
    {
        // action body
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Master")) {
            $id = $this->_getParam('id');
            $this->view->work = new Application_Model_Work($id);
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $id = $this->_getParam('id');
        $obj_work = new Application_Model_WorkStatusLogic(-1);
        echo $obj_work->fetchDataTableSelect($id);
    }

    public function addAction()
    {
        if(Application_Model_RolePermissionLogic::isPermitted("Work:Master")) {
            $obj_form = new Application_Form_WorkStatus();
            $id = $this->_getParam('id');
            $obj_form->work_id->setValue($id);
            $this->view->form = $obj_form;
            $obj_asitworkstatus = new Application_Model_WorkStatusLogic(-1);
            if($this->getRequest()->isPost()){
               $data=$this->getRequest()->getPost();
               if($obj_form->isValid($data)){
                $user = new Application_Model_UserLogic(-1);  
                $obj_asitworkstatus->set_work_id($obj_form->work_id->getValue());
                $obj_asitworkstatus->set_work_remarks($obj_form->work_remarks->getValue());
                $obj_asitworkstatus->set_work_status($obj_form->work_status->getValue());
                $obj_asitworkstatus->set_work_updated_by($user->getLoggedInUserId());
                $obj_asitworkstatus->set_work_created_by($user->getLoggedInUserId());
                $obj_asitworkstatus->save();
                
                $obj_work = new Application_Model_WorkLogic(-1);
                $obj_work->insertStatus($obj_form->work_id->getValue(), $obj_form->work_status->getValue(), $obj_form->work_remarks->getValue());
                
                $obj_email = new Application_Model_Email_Factory();
                $obj_email->sendWorkAllocationStatusEmail($obj_form->work_id->getValue());

                $sess = new Zend_Session_Namespace("msg");
                $sess->msg = "Status Updated Successfully!!!";
                $this->_redirect("dynasty/work/index");
               }
            }
        }else {
            throw new Zend_Controller_Action_Exception(Application_Model_Cache_Config::getConfig('AUTHENTICATION_ERROR'), 404);
        }
    }

}
