<?php

class Manage_ListController extends Zend_Controller_Action
{

    public function init() {
        $this->_helper->layout()->setLayout('manage');
    }

    public function indexAction()
    {
        $obj_email = new Application_Model_EmailScheduleLogic(-1);
        $emailUtil = new Application_Model_Email_Factory();
        foreach($obj_email->getCronEmails() as $email) {
            $emailUtil->sendScheduleEmail($email->id);
        }
    }
    
    public function addAction()
    {
        $layout = $this->_helper->layout();
        $layout->assign('breadcrumbs', array(array("title"=>"Stores", "url"=>"manage/list/index"), array("title"=>"Add Store", "url"=>"manage/list/add")));
        $layout->assign('page_title', "Add Store");
        $layout->assign('page_desc', "Want to list the store, fill enclosed form.");
        
        $obj_list = new Application_Model_ListLogic(-1);
        $this->view->locations = $obj_list->getOrderedDistinctLocation();
        
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->categories = $obj_cat->getParentCategory();
        
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $storeName = $data['storeName'];
            $category = $data['category'];
            $categories = $data['categories'];
            $tagLine = $data['tagLine'];
            $location = $data['location'];
            $address = $data['address'];
            $shortDescription = $data['shortDescription'];
            
            $obj_user = new Application_Model_UserLogic(-1);
            $user = $obj_user->getLoggedInUser();
            $obj_list->set_list_title($storeName);
            $obj_list->set_list_category($category);
            $obj_list->set_list_short_desc($shortDescription);
            $obj_list->set_list_desc("");
            $obj_list->set_list_image("");
            $obj_list->set_list_tag_line($tagLine);
            $obj_list->set_list_address($address);
            $obj_list->set_list_area($location);
            $obj_list->set_list_phone($user->get_user_mobile());
            $obj_list->set_list_email($user->get_user_email());
            $url = $obj_list->generateListUrl($storeName);
            $obj_list->set_list_website(Application_Model_Cache_Config::getConfig("SITE_URL").$url);
            $obj_list->set_list_logo("");
            $obj_list->set_list_is_claimed(true);
            $obj_list->set_list_url($url);
            $obj_list->set_list_type('N');
            $obj_list->set_list_status('A');
            $obj_list->set_list_user($user->get_id());
            $obj_list->set_list_review_score(0);
            $obj_list->set_list_review_total(0);
            $obj_list->set_list_updated_by($user->get_id());
            $obj_list->set_list_created_by($user->get_id());
            $obj_list->save();
            $lastInsertId = $obj_list->getAdapter()->lastInsertId();
            $obj_list_meta = new Application_Model_ListMetaLogic(-1);
            $obj_list_meta->set_list_id($lastInsertId);
            $obj_list_meta->set_list_fb("");
            $obj_list_meta->set_list_tweet("");
            $obj_list_meta->set_list_insta("");
            $obj_list_meta->set_list_amenities("");
            $obj_list_meta->set_list_target("");
            $obj_list_meta->set_list_tags("");
            $obj_list_meta->set_list_opening_days('');
            $obj_list_meta->set_list_opening_hours('');
            $obj_list_meta->set_list_updated_by($user->get_id());
            $obj_list_meta->set_list_created_by($user->get_id());
            $obj_list_meta->save();
            $obj_list_category = new Application_Model_ListCategoryLogic(-1);
            foreach($categories as $cat) {
                $obj_list_category->insertCategory($lastInsertId, $cat);
            }

            $sess = new Zend_Session_Namespace("msg");
            $enc = new Application_Model_Util_Encrypt();
            $sess->msg = "Your store/business has been added successfully. Please fill complete profile.";
            $this->_redirect("manage/list/desc/id/".$enc->hideContent($lastInsertId));
        }
    }
    
    public function descAction()
    {
        $enc = new Application_Model_Util_Encrypt();
        $this->view->list = $obj_list = new Application_Model_ListLogic($enc->showHiddenContent($this->_getParam('id')));
        $this->view->listMeta = $obj_list_meta = new Application_Model_ListMeta($obj_list->get_id());
        
        $layout = $this->_helper->layout();
        $layout->assign('breadcrumbs', array(array("title"=>"Stores", "url"=>"manage/list/index"), array("title"=>"Add Store Description", "url"=>"manage/list/desc")));
        $layout->assign('page_title', "Add Store Description For ");
        $layout->assign('page_desc', $obj_list->get_list_title());
        
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Your store/business information has been saved successfully. Please fill complete profile.";
            $this->_redirect("manage/list/meta/id/".$enc->hideContent($obj_list->get_id()));
        }
        
    }
    
    public function metaAction()
    {
        $enc = new Application_Model_Util_Encrypt();
        $this->view->encId = $this->_getParam('id');
        $this->view->list = $obj_list = new Application_Model_ListLogic($enc->showHiddenContent($this->_getParam('id')));
        $this->view->listMeta = $obj_list_meta = new Application_Model_ListMeta($obj_list->get_id());
        
        $layout = $this->_helper->layout();
        $layout->assign('breadcrumbs', array(array("title"=>"Stores", "url"=>"manage/list/index"), array("title"=>"Add Store Information", "url"=>"manage/list/meta")));
        $layout->assign('page_title', "Add Store Information For ");
        $layout->assign('page_desc', $obj_list->get_list_title());
        
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            
        }
        
    }
    
    public function uploadAction() {
        $enc = new Application_Model_Util_Encrypt();
        $id = $enc->showHiddenContent($this->_getParam('id'));
        
    }
    
    public function editAction()
    {
        $layout = $this->_helper->layout();
        $layout->assign('breadcrumbs', array(array("title"=>"Stores", "url"=>"manage/list/index"), array("title"=>"Add Store", "url"=>"manage/list/add")));
        $layout->assign('page_title', "Add Store Information");
        $layout->assign('page_desc', "Add more infromation of your store to generate more revenue.");
        
        $this->view->id = $id = $this->_getParam('id');
        $enc = new Application_Model_Util_Encrypt();
        $storeId = $enc->showHiddenContent($id);
        
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->categories = $obj_cat->getParentCategory();
        
        $this->view->list = $obj_list = new Application_Model_ListLogic($storeId);
        $this->view->locations = $obj_list->getOrderedDistinctLocation();
        $obj_list_meta = new Application_Model_ListMetaLogic(-1);
        $this->view->listMeta = $obj_list_meta->getMetaByListId($obj_list->get_id());
        $obj_list_img = new Application_Model_ListImageLogic(-1);
        $this->view->listImg = $obj_list_img->getActiveImage($obj_list->get_id());
        $obj_list_cat = new Application_Model_ListCategoryLogic(-1);
        $this->view->listImg = $obj_list_cat->getActiveCategory($obj_list->get_id());
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $storeName = $data['storeName'];
            $category = $data['category'];
            $tagLine = $data['tagLine'];
            $location = $data['location'];
            $address = $data['address'];
            $shortDescription = $data['shortDescription'];
            
            $obj_user = new Application_Model_UserLogic(-1);
            $user = $obj_user->getLoggedInUser();
            $obj_list->set_list_title($storeName);
            $obj_list->set_list_category($category);
            $obj_list->set_list_short_desc($shortDescription);
            $obj_list->set_list_desc("");
            $obj_list->set_list_image("");
            $obj_list->set_list_tag_line($tagLine);
            $obj_list->set_list_address($address);
            $obj_list->set_list_area($location);
            $obj_list->set_list_phone($user->get_user_mobile());
            $obj_list->set_list_email($user->get_user_email());
            $url = $obj_list->generateListUrl($storeName);
            $obj_list->set_list_website(Application_Model_Cache_Config::getConfig("SITE_URL").$url);
            $obj_list->set_list_logo("");
            $obj_list->set_list_is_claimed(true);
            $obj_list->set_list_url($url);
            $obj_list->set_list_type('N');
            $obj_list->set_list_status('A');
            $obj_list->set_list_user($user->get_id());
            $obj_list->set_list_review_score(0);
            $obj_list->set_list_review_total(0);
            $obj_list->set_list_updated_by($user->get_id());
            $obj_list->set_list_created_by($user->get_id());
            $obj_list->save();
            $obj_list_meta = new Application_Model_ListMetaLogic(-1);
            $obj_list_meta->set_list_id($lastInsertId);
            $obj_list_meta->set_list_fb("");
            $obj_list_meta->set_list_tweet("");
            $obj_list_meta->set_list_insta("");
            $obj_list_meta->set_list_amenities("");
            $obj_list_meta->set_list_target("");
            $obj_list_meta->set_list_tags("");
            $obj_list_meta->set_list_opening_days('');
            $obj_list_meta->set_list_opening_hours('');
            $obj_list_meta->set_list_updated_by($user->get_id());
            $obj_list_meta->set_list_created_by($user->get_id());
            $obj_list_meta->save();

            $sess = new Zend_Session_Namespace("msg");
            $enc = new Application_Model_Util_Encrypt();
            $sess->msg = "Your store/business information has been updated successfully.";
            $this->_redirect("manage/list/edit/id/".$enc->hideContent($lastInsertId));
        }
    }
    
}

