/* =========================================================
 * bootstrap-timepicker.js
 * http://www.github.com/jdewit/bootstrap-timepicker
 * =========================================================
 * Copyright 2012
 *
 * Created By:
 * Joris de Wit @joris_dewit
 * Gilbert @mindeavor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ========================================================= */

!function(b){var e=function(a,d){this.$element=b(a);this.options=b.extend({},b.fn.timepicker.defaults,d);this.minuteStep=this.options.minuteStep||this.minuteStep;this.disableFocus=this.options.disableFocus||this.disableFocus;this.template=this.options.template||this.template;this.open=!1;this.init()};e.prototype={constructor:e,init:function(){this.$element.on("click",b.proxy(this.show,this)).on("keyup",b.proxy(this.updateFromElementVal,this));switch(this.options.template){case "modal":this.$widget= b(this.options.modalTemplate).appendTo("body");break;case "dropdown":this.$widget=b(this.options.dropdownTemplate).appendTo("body")}this.$widget.on("click",b.proxy(this.click,this));b("html").on("click.timepicker.data-api",b.proxy(this.hide,this));this.setDefaultTime(this.options.defaultTime||this.defaultTime)},show:function(a){a.stopPropagation();a.preventDefault();this.$element.trigger("show");!0===this.disableFocus&&this.$element.blur();a=b.extend({},this.$element.offset(),{height:this.$element[0].offsetHeight}); "modal"===this.options.template?this.$widget.modal("show"):(this.$widget.css({top:a.top+a.height,left:a.left}),this.open||this.$widget.addClass("open"));this.open=!0;this.$element.trigger("shown");return this},hide:function(){this.$element.trigger("hide");"modal"===this.options.template?this.$widget.modal("hide"):this.$widget.removeClass("open");this.open=!1;this.$element.trigger("hidden");return this},setValues:function(a){var d,c=a.match(/(AM|PM)/i);c&&(d=c[1]);a=b.trim(a.replace(/(PM|AM)/i,"")); a=a.split(":");this.meridian=d;this.hour=parseInt(a[0]);this.minute=parseInt(a[1])},setDefaultTime:function(a){if(a){if("current"===a){var b=new Date,a=b.getHours(),b=Math.floor(b.getMinutes()/this.minuteStep)*this.minuteStep,c="AM";0===a?a=12:12<a?(a-=12,c="PM"):c="AM";this.hour=a;this.minute=b;this.meridian=c}else this.setValues(a);this.update()}},formatTime:function(a,b,c){return(10>a?"0"+a:a)+":"+(10>b?"0"+b:b)+" "+c},getTime:function(){return this.formatTime(this.hour,this.minute,this.meridian)}, setTime:function(a){this.setValues(a);this.update()},updateElement:function(){this.$element.val(this.getTime())},updateWidget:function(){this.$widget.find("td.bootstrap-timepicker-hour").text(this.hour).end().find("td.bootstrap-timepicker-minute").text(10>this.minute?"0"+this.minute:this.minute).end().find("td.bootstrap-timepicker-meridian").text(this.meridian)},update:function(){this.updateElement();this.updateWidget()},updateFromElementVal:function(){var a=this.$element.val();a&&(this.setValues(a), this.updateWidget())},click:function(a){a.stopPropagation();a.preventDefault();!0!==this.disableFocus&&this.$element.focus();if(a=b(a.target).closest("a").data("action"))this[a](),this.update()},incrementHour:function(){12===this.hour?(this.hour=1,this.toggleMeridian()):this.hour+=1},decrementHour:function(){1===this.hour?(this.hour=12,this.toggleMeridian()):this.hour-=1},incrementMinute:function(){var a=this.minute+this.minuteStep-this.minute%this.minuteStep;59<a?(this.incrementHour(),this.minute= a-60):this.minute=a},decrementMinute:function(){var a=this.minute-this.minuteStep;0>a?(this.decrementHour(),this.minute=a+60):this.minute=a},toggleMeridian:function(){this.meridian="AM"===this.meridian?"PM":"AM";this.update()}};b.fn.timepicker=function(a){return this.each(function(){var d=b(this),c=d.data("timepicker"),f="object"==typeof a&&a;c||d.data("timepicker",c=new e(this,f));if("string"==typeof a)c[a]()})};b.fn.timepicker.defaults={minuteStep:15,disableFocus:!1,defaultTime:"current",template:"dropdown", dropdownTemplate:'<div class="bootstrap-timepicker dropdown-menu"><table><tr><td><a href="#" data-action="incrementHour"><i class="icon-chevron-up"></i></a></td><td class="separator"></td><td><a href="#" data-action="incrementMinute"><i class="icon-chevron-up"></i></a></td><td><a href="#" data-action="toggleMeridian"><i class="icon-chevron-up"></i></a></td></tr><tr><td class="bootstrap-timepicker-hour"></td> <td class="separator">:</td><td class="bootstrap-timepicker-minute"></td> <td class="bootstrap-timepicker-meridian"></td></tr><tr><td><a href="#" data-action="decrementHour"><i class="icon-chevron-down"></i></a></td><td class="separator"></td><td><a href="#" data-action="decrementMinute"><i class="icon-chevron-down"></i></a></td><td><a href="#" data-action="toggleMeridian"><i class="icon-chevron-down"></i></a></td></tr></table></div>', modalTemplate:'<div class="bootstrap-timepicker modal hide fade in" style="top: 30%; margin-top: 0; width: 200px; margin-left: -100px;" data-backdrop="static"><div class="modal-header"><a href="#" class="close" data-action="hide">\u00d7</a><h3>Pick a Time</h3></div><div class="modal-content"><table><tr><td><a href="#" data-action="incrementHour"><i class="icon-chevron-up"></i></a></td><td class="separator"></td><td><a href="#" data-action="incrementMinute"><i class="icon-chevron-up"></i></a></td><td><a href="#" data-action="toggleMeridian"><i class="icon-chevron-up"></i></a></td></tr><tr><td class="bootstrap-timepicker-hour"></td> <td class="separator">:</td><td class="bootstrap-timepicker-minute"></td> <td class="bootstrap-timepicker-meridian"></td></tr><tr><td><a href="#" data-action="decrementHour"><i class="icon-chevron-down"></i></a></td><td class="separator"></td><td><a href="#" data-action="decrementMinute"><i class="icon-chevron-down"></i></a></td><td><a href="#" data-action="toggleMeridian"><i class="icon-chevron-down"></i></a></td></tr></table></div><div class="modal-footer"><a href="#" class="btn btn-primary" data-action="hide">Ok</a></div></div>'}; b.fn.timepicker.Constructor=e;b(function(){b("body").on("focus.timepicker.data-api",'[data-provide="timepicker"]',function(a){var d=b(this);d.data("timepicker")||(a.preventDefault(),d.timepicker(d.data()))})})}(window.jQuery);